using System;
using Server.Network;
using System.Collections;
using Server.Spells;
using Server.Spells.Necromancy;
using Server.Spells.First;
using Server.Spells.Second;
using Server.Spells.Fourth;
using Server.Spells.Fifth;
using Server.Mobiles;

namespace Server.Items
{
	public class HealingTotem : BaseTotem
	{
      [Constructable]
		public HealingTotem( int charges, Mobile owner ) : base( TotemType.Healing, charges, owner )
		{
			Name = String.Format( "{0} totem [{1}]", ( Owner.HeadArmor is ShamansMask ) ? "cleansing" : "healing", this.Owner.RawName.ToLower() );
			ItemID = Utility.RandomMinMax( 13814, 13815 );
		}
		
		public override void DoEffect( int count )
		{
			if ( count % 2 == 0 )
			{
//             this.PublicOverheadMessage( MessageType.Regular, 0x22, false, count.ToString() );
            
            Effects.PlaySound( this.Location, this.Map, 0x202 );
				Effects.SendLocationParticles( EffectItem.Create( this.Location, this.Map, EffectItem.DefaultDuration ), 0x376A, 8, 20, 5042 );
				ArrayList targets = new ArrayList();

				Map map = Owner.Map;

				if ( map != null )
				{
					IPooledEnumerable eable = map.GetMobilesInRange( this.Location, 5 );

					foreach ( Mobile m in eable )
					{
						if ( ( m.Player && m.AccessLevel == AccessLevel.Player ) || ( m is BaseCreature && (((BaseCreature)m).Controlled || ((BaseCreature)m).Summoned ) ) )
						{
							if ( !m.InLOS( this ) || m.Blessed || !m.Alive || m.IsDeadBondedPet || m.Hidden )
								continue;

							targets.Add( m );
						}
					}

					eable.Free();
				}

				if ( targets.Count > 0 )
				{
					for ( int i = 0; i < targets.Count; ++i )
					{
    					Mobile m = (Mobile)targets[i];
    					
    					if ( m == null || m.Deleted || !m.Alive || m.Hits >= m.HitsMax )
    						continue;
    					
    					if ( m.Poison != null )
    					{
    					   m.Poison = null;
                     m.FixedParticles( 0x373A, 10, 15, 5012, EffectLayer.Waist );
                     m.PlaySound( 0x1E0 );
                     
                     if ( Owner.HeadArmor is ShamansMask )
                        RemoveCurses( m );
                  }
    					else
    					{
    					   m.Heal( AOS.Scale( m.HitsMax, ( Owner.HeadArmor is ShamansMask && m == Owner ) ? 20 : Utility.RandomMinMax( 10, 15 ) ) );
    					   m.PlaySound( 0x5C9 );
    					   m.FixedEffect( 0x374A, 10, 20 );
    					   
                     if ( Owner.HeadArmor is ShamansMask )
                        RemoveCurses( m );
                  }
					}
				}
			}
      }
      
      private static void RemoveCurses( Mobile from )
      {
			StatMod mod;

			mod = from.GetStatMod( "[Magic] Str Offset" );
			if ( mod != null && mod.Offset < 0 )
				from.RemoveStatMod( "[Magic] Str Offset" );

			mod = from.GetStatMod( "[Magic] Dex Offset" );
			if ( mod != null && mod.Offset < 0 )
				from.RemoveStatMod( "[Magic] Dex Offset" );

			mod = from.GetStatMod( "[Magic] Int Offset" );
			if ( mod != null && mod.Offset < 0 )
				from.RemoveStatMod( "[Magic] Int Offset" );

			from.Paralyzed = false;

			EvilOmenSpell.CheckEffect( from );
			StrangleSpell.RemoveCurse( from );
			CorpseSkinSpell.RemoveCurse( from );
			CurseSpell.RemoveEffect( from );				
			BleedAttack.EndBleed( from, false );
			MortalStrike.EndWound( from );
					
			BuffInfo.RemoveBuff( from, BuffIcon.Bleed );
			BuffInfo.RemoveBuff( from, BuffIcon.MortalStrike );
			BuffInfo.RemoveBuff( from, BuffIcon.Clumsy );
			BuffInfo.RemoveBuff( from, BuffIcon.FeebleMind );
			BuffInfo.RemoveBuff( from, BuffIcon.Weaken );
			BuffInfo.RemoveBuff( from, BuffIcon.MassCurse );
      }

		public HealingTotem( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}